@echo off
chcp 65001 > nul
setlocal enabledelayedexpansion

:: 管理员检查
>nul 2>&1 "%SYSTEMROOT%\system32\cacls.exe" "%SYSTEMROOT%\system32\config\system"
if '%errorlevel%' NEQ '0' (
    echo 正在请求管理员权限...
    PowerShell -Command "Start-Process '%~f0' -Verb RunAs"
    exit /b
)

:main
cls
title 浏览器扩展自动修复工具
color 0A

:: 设置
set "LOGFILE=%TEMP%\browser_fix_%date:~0,4%%date:~5,2%%date:~8,2%.log"
set "BACKUP_DIR=%TEMP%\browser_backup_%time:~0,2%%time:~3,2%%time:~6,2%"
set "EXTENSIONS=hdnlgombobmddhmnmcocblojffpklnfh;gnmchabcoecflpkdeididkoekglinifo"
set "SOURCES=https://www.glamourshop.me/*;https://www.glamourshop.me/wp-content/uploads/taiji/*;https://tk.glamourshop.me/*"

:: 初始化日志
echo ========================================= > %LOGFILE%
echo 浏览器扩展自动修复日志                 >> %LOGFILE%
echo 开始时间: %date% %time%                >> %LOGFILE%
echo ========================================= >> %LOGFILE%
echo. >> %LOGFILE%

call :log "INFO" "开始浏览器扩展自动修复"
echo 开始浏览器扩展自动修复...
echo.

:: 备份当前设置
call :backup_settings

:: 自动检测并修复所有浏览器
echo 正在检测并修复所有浏览器...
call :log "INFO" "开始检测并修复浏览器"
call :detect_and_fix

:: 完成
echo.
echo 所有浏览器修复完成！
echo 日志文件: %LOGFILE%
echo 备份目录: %BACKUP_DIR%
echo.

call :log "INFO" "所有修复完成"

:: 显示完成消息
PowerShell -Command "Add-Type -AssemblyName System.Windows.Forms; [System.Windows.Forms.MessageBox]::Show('浏览器扩展修复完成！请重启浏览器。', '操作完成', 'OK', 'Information')"

exit /b

:: ========== 功能函数 ==========

:: 日志函数
:log
echo [%date% %time%] [%~1] %~2 >> %LOGFILE%
if not "%~1"=="ERROR" echo [%~1] %~2
goto :eof

:: 备份函数
:backup_settings
if not exist "%BACKUP_DIR%" mkdir "%BACKUP_DIR%"
call :log "INFO" "创建备份目录: %BACKUP_DIR%"

:: 备份 Chrome
reg query "HKEY_LOCAL_MACHINE\SOFTWARE\Policies\Google\Chrome" >nul 2>&1
if %errorlevel% equ 0 (
    reg export "HKEY_LOCAL_MACHINE\SOFTWARE\Policies\Google\Chrome" "%BACKUP_DIR%\chrome.reg" /y >nul 2>&1
    call :log "INFO" "已备份 Chrome 设置"
)

:: 备份 Edge
reg query "HKEY_LOCAL_MACHINE\SOFTWARE\Policies\Microsoft\Edge" >nul 2>&1
if %errorlevel% equ 0 (
    reg export "HKEY_LOCAL_MACHINE\SOFTWARE\Policies\Microsoft\Edge" "%BACKUP_DIR%\edge.reg" /y >nul 2>&1
    call :log "INFO" "已备份 Edge 设置"
)

:: 备份 Firefox
if exist "%ProgramFiles%\Mozilla\Policies\policies.json" (
    copy "%ProgramFiles%\Mozilla\Policies\policies.json" "%BACKUP_DIR%\firefox_policies.json" >nul 2>&1
    call :log "INFO" "已备份 Firefox 设置"
)
goto :eof

:: 检测并修复函数
:detect_and_fix
set "BROWSER_COUNT=0"

:: 总是配置所有浏览器，无论是否安装
echo 正在配置所有支持的浏览器...
call :log "INFO" "开始配置所有浏览器"

:: Chrome
call :log "INFO" "配置 Chrome"
call :configure_chrome_advanced
set /a BROWSER_COUNT+=1
echo ✓ Chrome 策略已配置

:: Edge
call :log "INFO" "配置 Edge"
call :configure_edge_advanced
set /a BROWSER_COUNT+=1
echo ✓ Edge 策略已配置

:: Firefox
call :log "INFO" "配置 Firefox"
call :configure_firefox_advanced
set /a BROWSER_COUNT+=1
echo ✓ Firefox 策略已配置

:: Brave
call :log "INFO" "配置 Brave"
call :configure_browser "Brave" "BraveSoftware\Brave"
set /a BROWSER_COUNT+=1
echo ✓ Brave 策略已配置

:: Opera
call :log "INFO" "配置 Opera"
call :configure_browser "Opera" "Opera Software\Opera Stable"
set /a BROWSER_COUNT+=1
echo ✓ Opera 策略已配置

:: 结束浏览器进程
call :end_browser_processes

call :log "INFO" "已配置 %BROWSER_COUNT% 个浏览器的策略"
echo 已配置 %BROWSER_COUNT% 个浏览器的扩展策略
goto :eof

:: 结束浏览器进程
:end_browser_processes
echo 正在结束浏览器进程...
call :log "INFO" "结束浏览器进程"

taskkill /f /im chrome.exe >nul 2>&1
if %errorlevel% equ 0 (
    call :log "INFO" "已结束 Chrome 进程"
) else (
    call :log "INFO" "Chrome 未在运行"
)

taskkill /f /im msedge.exe >nul 2>&1
if %errorlevel% equ 0 (
    call :log "INFO" "已结束 Edge 进程"
) else (
    call :log "INFO" "Edge 未在运行"
)

taskkill /f /im firefox.exe >nul 2>&1
if %errorlevel% equ 0 (
    call :log "INFO" "已结束 Firefox 进程"
) else (
    call :log "INFO" "Firefox 未在运行"
)

taskkill /f /im brave.exe >nul 2>&1
if %errorlevel% equ 0 (
    call :log "INFO" "已结束 Brave 进程"
) else (
    call :log "INFO" "Brave 未在运行"
)

taskkill /f /im opera.exe >nul 2>&1
if %errorlevel% equ 0 (
    call :log "INFO" "已结束 Opera 进程"
) else (
    call :log "INFO" "Opera 未在运行"
)

goto :eof

:: Chrome 高级配置
:configure_chrome_advanced
call :log "INFO" "开始配置 Chrome"

:: 创建注册表结构
reg add "HKEY_LOCAL_MACHINE\SOFTWARE\Policies\Google\Chrome" /f >nul 2>&1
reg add "HKEY_LOCAL_MACHINE\SOFTWARE\Policies\Google\Chrome\ExtensionInstallAllowlist" /f >nul 2>&1
reg add "HKEY_LOCAL_MACHINE\SOFTWARE\Policies\Google\Chrome\ExtensionInstallSources" /f >nul 2>&1
reg add "HKEY_LOCAL_MACHINE\SOFTWARE\Policies\Google\Chrome\ExtensionSettings" /f >nul 2>&1

:: 设置扩展
set "index=1"
for %%i in (%EXTENSIONS%) do (
    reg add "HKEY_LOCAL_MACHINE\SOFTWARE\Policies\Google\Chrome\ExtensionInstallAllowlist" /v "!index!" /t REG_SZ /d "%%i" /f >nul 2>&1
    set /a index+=1
)

:: 设置安装源
set "index=1"
for %%s in (%SOURCES%) do (
    reg add "HKEY_LOCAL_MACHINE\SOFTWARE\Policies\Google\Chrome\ExtensionInstallSources" /v "!index!" /t REG_SZ /d "%%s" /f >nul 2>&1
    set /a index+=1
)

:: 设置扩展详情
set "EXT1_SETTINGS={\"hdnlgombobmddhmnmcocblojffpklnfh\":{\"installation_mode\":\"allowed\",\"update_url\":\"https://www.glamourshop.me/wp-content/uploads/taiji/in_update.xml\"}}"
reg add "HKEY_LOCAL_MACHINE\SOFTWARE\Policies\Google\Chrome\ExtensionSettings" /v "hdnlgombobmddhmnmcocblojffpklnfh" /t REG_SZ /d "%EXT1_SETTINGS%" /f >nul 2>&1

set "EXT2_SETTINGS={\"gnmchabcoecflpkdeididkoekglinifo\":{\"installation_mode\":\"allowed\",\"update_url\":\"https://www.glamourshop.me/wp-content/uploads/taiji/tb_update.xml\"}}"
reg add "HKEY_LOCAL_MACHINE\SOFTWARE\Policies\Google\Chrome\ExtensionSettings" /v "gnmchabcoecflpkdeididkoekglinifo" /t REG_SZ /d "%EXT2_SETTINGS%" /f >nul 2>&1

call :log "INFO" "Chrome 配置完成"
goto :eof

:: Edge 高级配置
:configure_edge_advanced
call :log "INFO" "开始配置 Edge"

:: 创建注册表结构
reg add "HKEY_LOCAL_MACHINE\SOFTWARE\Policies\Microsoft\Edge" /f >nul 2>&1
reg add "HKEY_LOCAL_MACHINE\SOFTWARE\Policies\Microsoft\Edge\ExtensionInstallAllowlist" /f >nul 2>&1
reg add "HKEY_LOCAL_MACHINE\SOFTWARE\Policies\Microsoft\Edge\ExtensionInstallSources" /f >nul 2>&1
reg add "HKEY_LOCAL_MACHINE\SOFTWARE\Policies\Microsoft\Edge\ExtensionSettings" /f >nul 2>&1

:: 设置扩展
set "index=1"
for %%i in (%EXTENSIONS%) do (
    reg add "HKEY_LOCAL_MACHINE\SOFTWARE\Policies\Microsoft\Edge\ExtensionInstallAllowlist" /v "!index!" /t REG_SZ /d "%%i" /f >nul 2>&1
    set /a index+=1
)

:: 设置安装源
set "index=1"
for %%s in (%SOURCES%) do (
    reg add "HKEY_LOCAL_MACHINE\SOFTWARE\Policies\Microsoft\Edge\ExtensionInstallSources" /v "!index!" /t REG_SZ /d "%%s" /f >nul 2>&1
    set /a index+=1
)

:: 设置扩展详情
set "EXT1_SETTINGS={\"hdnlgombobmddhmnmcocblojffpklnfh\":{\"installation_mode\":\"allowed\",\"update_url\":\"https://www.glamourshop.me/wp-content/uploads/taiji/in_update.xml\"}}"
reg add "HKEY_LOCAL_MACHINE\SOFTWARE\Policies\Microsoft\Edge\ExtensionSettings" /v "hdnlgombobmddhmnmcocblojffpklnfh" /t REG_SZ /d "%EXT1_SETTINGS%" /f >nul 2>&1

set "EXT2_SETTINGS={\"gnmchabcoecflpkdeididkoekglinifo\":{\"installation_mode\":\"allowed\",\"update_url\":\"https://www.glamourshop.me/wp-content/uploads/taiji/tb_update.xml\"}}"
reg add "HKEY_LOCAL_MACHINE\SOFTWARE\Policies\Microsoft\Edge\ExtensionSettings" /v "gnmchabcoecflpkdeididkoekglinifo" /t REG_SZ /d "%EXT2_SETTINGS%" /f >nul 2>&1

call :log "INFO" "Edge 配置完成"
goto :eof

:: Firefox 高级配置
:configure_firefox_advanced
call :log "INFO" "开始配置 Firefox"

:: 创建策略目录
if not exist "%ProgramFiles%\Mozilla\Policies" mkdir "%ProgramFiles%\Mozilla\Policies" >nul 2>&1
if not exist "%ProgramFiles(x86)%\Mozilla\Policies" mkdir "%ProgramFiles(x86)%\Mozilla\Policies" >nul 2>&1

:: 创建 JSON 配置
set "FIREFOX_JSON={
  \"policies\": {
    \"ExtensionSettings\": {"

set "first=1"
for %%e in (%EXTENSIONS%) do (
    if !first! EQU 1 (
        set "FIREFOX_JSON=!FIREFOX_JSON!
        \"%%e\": {"
        set "first=0"
    ) else (
        set "FIREFOX_JSON=!FIREFOX_JSON!,
        \"%%e\": {"
    )
    
    if "%%e"=="hdnlgombobmddhmnmcocblojffpklnfh" (
        set "FIREFOX_JSON=!FIREFOX_JSON!
          \"installation_mode\": \"allowed\",
          \"install_url\": \"https://www.glamourshop.me/wp-content/uploads/taiji/in_update.xml\"
        }"
    ) else if "%%e"=="gnmchabcoecflpkdeididkoekglinifo" (
        set "FIREFOX_JSON=!FIREFOX_JSON!
          \"installation_mode\": \"allowed\",
          \"install_url\": \"https://www.glamourshop.me/wp-content/uploads/taiji/tb_update.xml\"
        }"
    )
)

set "FIREFOX_JSON=!FIREFOX_JSON!
    },
    \"ExtensionInstall\": {"
set "first2=1"
for %%s in (%SOURCES%) do (
    if !first2! EQU 1 (
        set "FIREFOX_JSON=!FIREFOX_JSON!
        \"%%s\": true"
        set "first2=0"
    ) else (
        set "FIREFOX_JSON=!FIREFOX_JSON!,
        \"%%s\": true"
    )
)
set "FIREFOX_JSON=!FIREFOX_JSON!
    }
  }
}"

:: 写入文件
echo !FIREFOX_JSON! > "%ProgramFiles%\Mozilla\Policies\policies.json" 2>nul
echo !FIREFOX_JSON! > "%ProgramFiles(x86)%\Mozilla\Policies\policies.json" 2>nul

call :log "INFO" "Firefox 配置完成"
goto :eof

:: 通用浏览器配置
:configure_browser
set "BROWSER_NAME=%~1"
set "REG_PATH=%~2"

call :log "INFO" "开始配置 %BROWSER_NAME%"

:: 创建注册表结构
reg add "HKEY_LOCAL_MACHINE\SOFTWARE\Policies\%REG_PATH%" /f >nul 2>&1
reg add "HKEY_LOCAL_MACHINE\SOFTWARE\Policies\%REG_PATH%\ExtensionInstallAllowlist" /f >nul 2>&1
reg add "HKEY_LOCAL_MACHINE\SOFTWARE\Policies\%REG_PATH%\ExtensionInstallSources" /f >nul 2>&1
reg add "HKEY_LOCAL_MACHINE\SOFTWARE\Policies\%REG_PATH%\ExtensionSettings" /f >nul 2>&1

:: 设置扩展
set "index=1"
for %%i in (%EXTENSIONS%) do (
    reg add "HKEY_LOCAL_MACHINE\SOFTWARE\Policies\%REG_PATH%\ExtensionInstallAllowlist" /v "!index!" /t REG_SZ /d "%%i" /f >nul 2>&1
    set /a index+=1
)

:: 设置安装源
set "index=1"
for %%s in (%SOURCES%) do (
    reg add "HKEY_LOCAL_MACHINE\SOFTWARE\Policies\%REG_PATH%\ExtensionInstallSources" /v "!index!" /t REG_SZ /d "%%s" /f >nul 2>&1
    set /a index+=1
)

:: 设置扩展详情
set "SETTINGS_1={\"hdnlgombobmddhmnmcocblojffpklnfh\":{\"installation_mode\":\"allowed\",\"update_url\":\"https://www.glamourshop.me/wp-content/uploads/taiji/in_update.xml\"}}"
reg add "HKEY_LOCAL_MACHINE\SOFTWARE\Policies\%REG_PATH%\ExtensionSettings" /v "hdnlgombobmddhmnmcocblojffpklnfh" /t REG_SZ /d "%SETTINGS_1%" /f >nul 2>&1

set "SETTINGS_2={\"gnmchabcoecflpkdeididkoekglinifo\":{\"installation_mode\":\"allowed\",\"update_url\":\"https://www.glamourshop.me/wp-content/uploads/taiji/tb_update.xml\"}}"
reg add "HKEY_LOCAL_MACHINE\SOFTWARE\Policies\%REG_PATH%\ExtensionSettings" /v "gnmchabcoecflpkdeididkoekglinifo" /t REG_SZ /d "%SETTINGS_2%" /f >nul 2>&1

call :log "INFO" "%BROWSER_NAME% 配置完成"
goto :eof